import numpy as np

# +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
# First, using the method from Brian and Bob.
# +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

# Generate a dummy array with a constant binning on a logarithmic scale.
start_exponent = 0
stop_exponent = 3
num_bins = 10
x = np.logspace(start_exponent, stop_exponent, num=num_bins, base=10.0)

# Check the binning of the array on a logarithmic scale.
logged_x = np.log(x)
print("1 - Bin width on a logarithmic scale before shift, ", np.diff(logged_x))

# Shift the array by half of the 'bin'.
xdiff = np.append(np.diff(x), x[-1] - x[-2])
x -= xdiff / 2

# Check the binning of the array on a logarithmic scale, after the shift.
print("1 - Bin width on a logarithmic scale after shift, ", np.diff(x))

# +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
# Second, using the method from Yuanpeng
# +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

# Generate a dummy array with a constant binning on a logarithmic scale.
start_exponent = 0
stop_exponent = 3
num_bins = 10
x = np.logspace(start_exponent, stop_exponent, num=num_bins, base=10.0)

# Check the binning of the array on a logarithmic scale.
logged_x = np.log(x)
print("2 - Bin width on a logarithmic scale before shift, ", np.diff(logged_x))

# Shift the array by half of the 'bin'.
x = np.log(x)
bin_size = x[-1] - x[-2]
x = np.exp(x - bin_size / 2.)

# Check the binning of the array on a logarithmic scale, after the shift.
logged_x = np.log(x)
print("2 - Bin width on a logarithmic scale after shift, ", np.diff(logged_x))