! For the polar angle part, since projection is involved and therefore
! we need to guarantee that the projection is uniform. We don't need
! to do this for the phi angle since only rotation is involved in
! that case.
polar_ang = dacos(2.0d0*(rmca_ran(1)-0.5d0))
azim_ang = rmca_ran(1) * 2.0d0 * pi
rand_x = delta(move_type) * dsin(polar_ang) * dcos(azim_ang)
rand_y = delta(move_type) * dsin(polar_ang) * dsin(azim_ang)
rand_z = delta(move_type) * dcos(polar_ang)
! We go from the Cartesian coordinates to fractional with respect
! to the lattice.
move(4) = rand_x * inv_vectors_init(1,1) + &
  rand_y * inv_vectors_init(1,2) + &
  rand_z * inv_vectors_init(1,3)
move(5) = rand_x * inv_vectors_init(2,1) + &
  rand_y * inv_vectors_init(2,2) + &
  rand_z * inv_vectors_init(2,3)
move(6) = rand_x * inv_vectors_init(3,1) + &
  rand_y * inv_vectors_init(3,2) + &
  rand_z * inv_vectors_init(3,3)
