Here we want to generate a cylinder nanowire, with limited dimension in 2D and the other dimension should be infinite. The cylinder axis lies along the b-axis. With `data2config`, we can do this. However, the original version can only align the cylinder axis along the c-axis. So, we take the source code and make some changes to allow the alignment along a specified axis. The new code and compiled executable on Linux is included here. Following is the command to generate the nanowire, with the cylinder axis lying along the b-axis.

```
./data2config -noannotate -order "[Nb Ga Si Zn Mg Cu Ca O]" -shape cylinder -nano "[30 117.028456 117.028456]" -axis b -nanobox "[4 1 2]" -rmc6f new_T_Nb2O5_vesta_init.cif
```

> The `-nano` flag specifies the nanowire size. The first value is the radius and the third value is the length. The second number is not used for the cylinder generation. The `-nanobox` flag specifies the multipliers for each dimension concerning the final supercell box size. This is useful for leaving enough space for the nanowire to avoid atoms seeing their mirrors along the direction where the size is limited (i.e., nano). So, the actual supercell size will be 30\*4, 117.028456\*1 and 117.028456\*4, respectively. So, in this case, the b-direction still keeps the periodic boundary condition and therefore can be considered as infinite.