Texture Correction for Fe45Cr
===

1. It seems this sample is with stronger texture effect, causing weird behavior in the high angle region. If you grab the files ending with "_corrected_bkg_rm_fittedbkg.dat", you will see the input data for the second stage correction. Those files are the scattering patterns for each of the 2Theta band after the first stage correction and background subtraction. For the background subtraction, we fitted an exponential function with the form of 'a + b * exp[-c * Q^2]' and after the subtraction, we expect the pattern sitting on the baseline, i.e., 0. Here below I am showing some of the patterns with the background subtracted, from which you can see the weird effect in the patterns for 157 and 162. For the two regions labeled out with red arrows, there are no peaks at all for 157 and 162, in which case there is no hope for any corrections and therefore we have to remove them. To do this, we can either delete all files corresponding to the two 2Theta's. Or, we can change the input change file to remove them from group. You can find my latest input json file at `/SNS/users/y8z/NOM_Shared/Yuanpeng/texture_correction_Mar2025/Fe45Cr_ZYP/ttheta_group_params_new_new_new_new_new_new_new.json`

	![problem](https://flv.iris-home.net/imgs/problem.png)

2. Though we implemented the background subtraction before the second stage correction, still sometimes the patterns are not perfectly suitable for the integration purpose. In some regions, the pattern is either above the baseline by a bit offset or part of the peak is below the baseline. This makes the peak area calculation and therefore the spherical harmonics fitting inaccurate, yielding weirdly looking outcome. For example, if part of the peak is below the baseline, there are some negative intensities, potentially making the overall intensity close to 0. The fitted coefficient then could be very big, leading to a huge peak with part of the peak above and part of the peak below the baseline. To solve the issue, I did change the script a bit to offset the pattern after the background subtraction to make sure we don't have any negative intensity. The new script is located at `/SNS/users/y8z/NOM_Shared/Yuanpeng/texture_correction_Mar2025/Fe45Cr_ZYP/texture_proc_real_1step_not_aligned_2step_aligned.py`

3. The original chunk definition is too coarse in some regions for both group-1 and group-2. You can find the chunk definition in my new json file mentioned above.

4. When changing the chunk definition, we want to make sure that the number of entries in `LinLimit` is the same as the number of entries in `QChunkDef`.

5. After the two-step correction, we only care about the region of a bank that we are going to use in the finally merged data. For example, for bank-1 to bank-4, we will probably not use the region above 4.0 so even they look weird, it is still OK since we are not going to use it. Also, since we were doing the correction for group-1 and group-2 (defined in the json file) independently, even though the high Q region in group-1 turns out to be garbage, the high Q region in group-2 (which we will be using at high-Q) is still fine.

6. After the correction, we will see quite a few stage-like behavior especially in the high Q region, as shown below,

	![final_manual](https://flv.iris-home.net/imgs/final_manual.png)

	this is somewhat unavoidable and we don't have an automated solution to deal with this. We have to manually offset the data in relevant regions to make smooth connections.