# import mantid algorithms, numpy and matplotlib
from mantid.simpleapi import *
import matplotlib.pyplot as plt
import numpy as np
import os
from pathlib import Path

nxs_file = "./SofQ/NOM_Si_640e.nxs"
out_dir = "./texture_proc"

stem_name = os.path.basename(nxs_file).split(".")[0]

if stem_name not in mtd:
    LoadNexus(
        Filename=nxs_file,
        OutputWorkspace=stem_name
    )

Path(out_dir).mkdir(parents=True, exist_ok=True)

for i in range(mtd[stem_name].getNumberHistograms()):
    x_tmp = mtd[stem_name].readX(i)
    y_tmp = mtd[stem_name].readY(i)
    y_tmp = np.insert(y_tmp, 0, y_tmp[0])
    spec_id = mtd[stem_name].getSpectrum(i).getSpectrumNo()
    out_file = os.path.join(
        out_dir,
        f"{stem_name}_bank{spec_id}.dat"
    )
    with open(out_file, "w") as f:
        f.write(f"{len(x_tmp)}\n\n")
        for j, item in enumerate(x_tmp):
            f.write("{0:10.4F}{1:20.5F}\n".format(item, y_tmp[j]))