A typical bond valence sum (BVS) input chunk in the RMCProfile .dat file will be something like,

```
BVS ::
  > ATOM :: A B C D E
  > WEIGHTS :: 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05
  > OXID :: +1 +5 -2 -1 -1
  > RIJ :: 0.0 1.26 1.36 1.66 1.33 1.77 2.22 0.0 0.0 0.0
  > BVAL :: 0.0 0.37 0.37 0.37 0.37 0.37 0.37 0.0 0.0 0.0
  > CUTOFF :: 0.0 5.5 5.5 5.5 5.5 5.5 5.5 0.0 0.0 0.0
  > SAVE :: 500000
  > UPDATE :: 300000
  > BVS_WEIGHT_FACTOR :: 1
```

> Some important notes concerning the parameters input will be presented at the very bottom. Make sure you don't miss them.

where `A-E` in the `ATOM` line are placeholders for the atom types involved in the RMCProfile .dat file. The order here has to agree with that in the `ATOMS ::` line in the RMCProfile .dat file. The `WEIGHTS ::` line specifies the relative weight that we want to assign to each pair of bonding. The weights included in this line are for internally weighting among those different bonding. The `BVS_WEIGHT_FACTOR ::` line then specifies the weight corresponding to the contribution to the chi square from BVS. If we are using the weight optimization capability, we can always leave the value for 'BVS_WEIGHT_FACTOR ::' as 1. Otherwise, the larger the value is, the stronger the weight will be. The `OXID ::` line just specifies the ideal valence for each atom type, following the order. The `RIJ ::` and `BVAL ::` lines specify the two critical parameters for the BVS calculation. Formulation can be found [here](https://en.wikipedia.org/wiki/Bond_valence_method). The parameters are tabulated and can be downloaded [here](https://www.iucr.org/__data/assets/file/0011/150779/bvparm2020.cif) as the CIF format -- we can just open it with text editor and read out the parameters for a specific bonding. The chunk in the CIF file to pay attention to will be like this,

```
loop_
   _valence_param_atom_1
   _valence_param_atom_1_valence
   _valence_param_atom_2
   _valence_param_atom_2_valence
   _valence_param_Ro
   _valence_param_B
   _valence_param_ref_id
   _valence_param_details

Ac 3   O  -2    2.24     0.37     b   ?
Ac 3   O  -2    2.29     0.35     p   ?
Ac 3   F  -1    2.13     0.37     b   ?
Ac 3   F  -1    2.10     0.40     p   ?
Ac 3   Cl -1    2.63     0.37     b   ?
...
...
...
```

where `_valence_param_Ro` refers to the `RIJ ::` parameter and `_valence_param_B` refers to the `BVAL ::` parameter. The `CUTOFF ::` line specifies to what distance we will be calculating the BVS for a certain bond. Given the exponential decay nature of the formulation, having something like 5 or 6 is probably enough -- for sure we can set it to very large but that will requires much heavier calculation due to large number of pairs to compute, without that much gain in accuracy. The `SAVE ::` and `UPDATE ::` lines are pretty much technical to RMCProfile and we can just leave them as is.

> N.B. For `WEIGHTS ::`, `RIJ ::`, `BVAL ::` and `CUTOFF ::` lines, the parameters should be given following the order of bonds. Taking the example presented here where we have 5 atom types, `A-E`, the order will be `A-B, A-C, A-D, A-E, B-C, B-D, B-E, C-D, C-E, D-E`. Attention needs to be paid to the difference from the minimum distance setup in RMCProfile, where alike pairs `A-A, B-B, ...` are also included -- for the BVS calculation, we don't want to consider bonding of atoms with other atoms of the same type.

> N.B. If we don't want to consider certain pairs of atoms to be bonded, we can just set parameters (`RIJ ::`, `BVAL ::` and `CUTOFF ::`) for those unwanted pairs to `0`. We then don't need to worry about the `WEIGHTS ::` since the unwanted pairs will contribute 0 in this case anyhow.

---

Yuanpeng Zhang @ 10/16/2025 12:30:12 EDT

SNS-HFIR, ORNL

---