The `neighbour_list` program only works with the old format of the supercell configuration.
These days we almost always use the `rmc6f` format, but before this format, there was an old
version of the configuration in the `rmc3` format. The `data2config` program can be used to
convert from `rmc6f` to `rmc3` (with the extension of `cfg`). For the conversion, we basically
want to generate a `1x1x1` 'supercell' from the input `rmc6f` configuration, so nothing is
really happening except from the format conversion.

The `neighbour_list` command can then be run with the created `cfg` file from previous step,
and we just need to follow the prompt to provide answers to those questions about the center
and surrounding atoms, the maximum distance between them and the output file. Multiple files
can be generated by answer `y` to the question `Produce another file (y/<n>)`.

Then we need to manually prepare a `.poly` file containing the information about the expected
bond lengths regarding the polyhedron. The input lines are specific to each type of supported
polyhedron -- see section 4.9 in the manual. Apart from the expected bond length is each line,
two entries are also expected in each line, to specify the weight for bond and angle constraint,
respectively. The weight is applied in the positive way, i.e., the larger of the number, the
stronger weight to be applied.

> For the `get_poly_gapo4` command involved in `ex_6`, it is just a bash script that goes over
all the mentioned steps here in a single shot. The contents of the script are pasted below.
Basically, the first two lines run the `data2config` for the format conversion. The following
lines are for preparing the input file for running `neighbour_list` and then running the program.
Then we prepare the `.poly` file by filling in the necessary contents, which is, again, specific
to the type of polyhedron for `ex_6`.


```bash
echo $1 > .rmc_tempy
data2config -rmc3 -order [Ga P O] -supercell [1 1 1] $1.rmc6f < .rmc_tempy > .delete_me
echo $1.cfg > .rmc_tempy
echo 1 >> .rmc_tempy
echo 3 >> .rmc_tempy
echo 2.5 >> .rmc_tempy
echo $1.alo >> .rmc_tempy
echo y >> .rmc_tempy
echo 3 >> .rmc_tempy
echo 1 >> .rmc_tempy
echo 2.5 >> .rmc_tempy
echo $1.oal >> .rmc_tempy
echo y >> .rmc_tempy
echo 2 >> .rmc_tempy
echo 3 >> .rmc_tempy
echo 2.5 >> .rmc_tempy
echo $1.po >> .rmc_tempy
echo y >> .rmc_tempy
echo 3 >> .rmc_tempy
echo 2 >> .rmc_tempy
echo 2.5 >> .rmc_tempy
echo $1.op >> .rmc_tempy
echo n >> .rmc_tempy
neighbour_list < .rmc_tempy >> .delete_me
echo Bondlength  Bondweight  Angleweight > $1.poly
echo 1.820       8000        2400 >> $1.poly
echo 1.538       16000       4800 >> $1.poly
rm .rmc_tempy
rm .delete_me
rm $1.cfg
```

---

Yuanpeng Zhang @ 07/29/2025 09:36:18 EST

SNS-HFIR, ORNL

---