Build LAMMPS with RMCProfile
===

1. We first need to compile `LAMMPS` separately to obtain the library file `liblammps.so.0`, together with a soft link file `liblammps.so` pointing to the library file. Once we have the compiled `liblammps.so.0` library file, creating the soft link is as simple as running,

    ```
    ln -s liblammps.so.0 liblammps.so
    ```

    - The `LAMMPS` source codes are hosted on [GitHub](https://github.com/lammps/lammps) and the building instructions can be found [here](https://docs.lammps.org/Build_cmake.html)

        > Starting from the `Stable release candidate 2 August 2023` (see the pull request [here](https://github.com/lammps/lammps/pull/3825)), `LAMMPS` changed the Fortran interface. I haven't checked how we can work with the new interface. The following compiling therefore will only work seamlessly with the version of `LAMMPS` before the aforementioned release. I am not sure whether or not the old wrapper will work with the newer version of `LAMMPS`. In case not, we then have to spend some time checking how to make the new wrapper working with RMCProfile.

    - Here follows is a bare minimum example for building `LAMMPS`,

        ```
        source /home/y8z/intel/oneapi/setvars.sh
        cmake ../cmake -D CMAKE_CXX_COMPILER=icx-cc
        cmake ../cmake -D BUILD_MPI=no -D BUILD_OMP=yes -D PKG_OPENMP=yes -D BUILD_SHARED_LIBS=yes -D PKG_REAXFF=yes -D PKG_EXTRA-PAIR=yes
        ```

        > Here I am using the intel `oneapi` installed into my own area on Big Bird. It seems that intel changes the compiler name for C++ to `icx-cc` instead of the old `icc`.

        > The `-D BUILD_SHARED_LIBS=yes` flags tell the compiler to create the shared library file we need.

        > The implementation of `LAMMPS` in RMCProfile is serial so we don't need the MPI build for `LAMMPS`.

        > The `-D PKG_REAXFF=yes` worries about enabling the `ReaxFF` potential. It is through this kind of flags that `LAMMPS` build controls what potentials to compile.

2. Next we need to build the `LAMMPS` wrapper -- source codes for the wrapper were provided with the `LAMMPS` source codes.

    > Starting from the `Stable release candidate 2 August 2023` (see the pull request [here](https://github.com/lammps/lammps/pull/3825)), `LAMMPS` changed the Fortran interface. I haven't checked how we can work with the new interface. The following compiling therefore will only work seamlessly with the version of `LAMMPS` before the aforementioned release. I am not sure whether or not the old wrapper will work with the newer version of `LAMMPS`. In case not, we then have to spend some time checking how to make the new wrapper working with RMCProfile.

    In the `RMCProfile` repo (the `lammps_rmc_ready` branch), under the `ubuntu1804-cuda-intel` directory, we have a `Makefile_lammps_wrapper_oneAPI` file for building the `LAMMPS` wrapper, creating the library file `liblammps_fortran.so`.

3. Then we just need to link the library when compiling the RMCProfile executable, including the link to both the `liblammps.so` and `liblammps_fortran.so` libraries. The `Makefile_mpi_oneAPI` file can be used as the reference about the library linking and the bash script `build_rmcprofile_lammps.sh` combines the step 2 & 3.